//
//  GMSSettingsURLAddViewController.m
//  GMS Sample
//
//  Created by Arkady on 8/8/13.
//  Copyright (c) 2013 Genesys. All rights reserved.
//

#import "GMSSettingsURLAddViewController.h"
#import "GMSAppDelegate.h"

@interface GMSSettingsURLAddViewController ()

@end

@implementation GMSSettingsURLAddViewController


- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    [_urlTextField becomeFirstResponder];
}

#pragma mark - TextField delegates

//Dismiss keyboard when Return key is pressed
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    if (appDelegate.serverURLSelected == -1) {
        //We are adding new URL
        [appDelegate.serverURLs addObject:textField.text];
        appDelegate.serverURLSelected = appDelegate.serverURLs.count - 1;
    }
    else {
        [appDelegate.serverURLs replaceObjectAtIndex:_editIndex withObject:textField.text];
    }
    [textField resignFirstResponder];
    [_parentTableView reloadData];
    [self.navigationController popViewControllerAnimated:YES];
    return YES;
}


- (void)viewDidUnload {
    [self setUrlTextField:nil];
    [super viewDidUnload];
}
@end
